Imports System.Threading

Public Class IHaveNoIdea
    Private refCount As Long
    Public Sub AddRef()
        Interlocked.Increment(refCount)
    End Sub
    Public Sub Release()
        Interlocked.Decrement(refCount)
        If refCount = 0 Then
            GC.Collect()
        End If
    End Sub
End Class


'Friend Class WorkerClass
'    Public Sub DoSomeWork()
'        Monitor.Enter(Me)
'        Try
'            ' Travailler.
'            Dim i As Integer
'            For i = 0 To 5
'                Console.WriteLine("Le travailleur dit : {0},", i)
'                Thread.Sleep(100)
'            Next
'        Finally
'            Monitor.Exit(Me)
'        End Try
'    End Sub
'End Class

Friend Class WorkerClass
    Public Sub DoSomeWork()
        SyncLock Me.GetType
            ' Travailler.
            Dim i As Integer
            For i = 0 To 5
                Console.WriteLine("Le travailleur dit : {0},", i)
                Thread.Sleep(100)
            Next

        End SyncLock
    End Sub
End Class

Module Module1
    ' Construire l'objet Worker partag.
    Public w As WorkerClass = New WorkerClass()

    Sub Main()
        ' Crer trois threads secondaires,
        ' chacun faisant appel au mme objet
        ' partag.
        Dim workerThreadA As Thread = New Thread(AddressOf w.DoSomeWork)
        Dim workerThreadB As Thread = New Thread(AddressOf w.DoSomeWork)
        Dim workerThreadC As Thread = New Thread(AddressOf w.DoSomeWork)

        ' Maintenant les lancer (et ralentir les oprations).
        workerThreadA.Start()
        Thread.Sleep(100)
        workerThreadB.Start()
        Thread.Sleep(100)
        workerThreadC.Start()


    End Sub

End Module
